package com.agilex.healthcare.veteranappointment.validator;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorHelper {
    public ValidatorHelper() {
    }

    public static ValidationError validateIsNotNull(Object object, ValidationError validationError) {
        ValidationError error = null;
        if(object == null) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateIsNotBlankOrNull(String string, ValidationError validationError) {
        ValidationError error = null;
        if(string == null || string.length() == 0) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateDateIsNotNull(Date date, ValidationError validationError) {
        ValidationError error = null;
        if(date == null) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateInclusiveTextLength(String text, int length, ValidationError validationError) {
        ValidationError error = null;
        if(text != null && text.length() > length) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateInclusiveNumericBounds(int value, int upperBound, int lowerBound, ValidationError validationError) {
        ValidationError error = null;
        if(value < lowerBound || value > upperBound) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateInclusiveNumericBounds(double value, double upperBound, double lowerBound, ValidationError validationError) {
        ValidationError error = null;
        if(value < lowerBound || value > upperBound) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateNonNegative(int value, ValidationError validationError) {
        ValidationError error = null;
        if(value < 0) {
            error = validationError;
        }

        return error;
    }

    public static ValidationError validateNonNegative(double value, ValidationError validationError) {
        ValidationError error = null;
        if(value < 0.0D) {
            error = validationError;
        }

        return error;
    }

    public static boolean isPhoneNumberLengthValid(String phoneNumber) {
        return phoneNumber.length() >= 10 && phoneNumber.length() <= 50;
    }

    public static boolean isPhoneNumberHasMinDigits(String phoneNumber) {
        int count = 0;
        boolean result = false;

        for(int i = 0; i < phoneNumber.length(); ++i) {
            if(phoneNumber.charAt(i) >= 48 && phoneNumber.charAt(i) <= 57) {
                ++count;
                if(count >= 10) {
                    result = true;
                    break;
                }
            }
        }

        return result;
    }

    public static boolean isPhoneNumberValidCharacters(String phoneNumber) {
        Pattern pattern = Pattern.compile("^[x0-9\\.\\-\\(\\)\\+\\s]+$");
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isEmailLengthValid(String email) {
        return email.length() >= 3 && email.length() <= 50;
    }

    public static boolean isEmailAddressFormatValid(String email) {
        Pattern pattern = Pattern.compile(".*\\.\\..*");
        Matcher matcher = pattern.matcher(email);
        if(matcher.matches()) {
            return false;
        } else {
            pattern = Pattern.compile("^\\..*");
            matcher = pattern.matcher(email);
            if(matcher.matches()) {
                return false;
            } else {
                pattern = Pattern.compile("^[a-zA-Z0-9\\-!#%&\':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\\\._`\\{\\|\\}~@]*[a-zA-Z0-9\\-!#%&\':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\_`\\{\\|\\}~@]+@[a-zA-Z0-9\\-:-\\[\\]]+(?:\\.[a-zA-Z0-9\\-:-]+)*$");
                matcher = pattern.matcher(email);
                return matcher.matches();
            }
        }
    }
}

